/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_TUS_INTERFACE_H
#define _SCE_TUS_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce { 
	namespace Toolkit {
	namespace NP {

	/// @brief
	/// The namespace containing PSN TUS (title user storage) functionality.
	///	
	/// The namespace containing PSN TUS (title user storage) functionality.
	namespace TUS {

	/// @brief
	/// The external interface to the PSN TUS (title user storage) functionality.
	///	
	/// The external interface to the PSN TUS (title user storage) functionality.
	/// This class is used to set and obtain variables and data from a TUS server.
	class Interface
	{
	public:

		/// @brief 
		/// Sets a specified user's TUS variables.
		///
		/// Sets a specified user's TUS variables.
		///
		/// @param 	params			The input parameters required to set the TUS variables of the specified user.
		/// @param	async			A flag that indicates whether the function is non-blocking or blocking.
		///							Defaults to true so the function is non-blocking by default.
		///
		/// @retval					SCE_TOOLKIT_NP_SUCCESS				The operation was successful.
		/// @retval					SCE_TOOLKIT_NP_OFFLINE				The operation failed because the user is not connected to the network.  
		/// @retval					SCE_TOOLKIT_NP_INVALID_POINTER		The operation failed because the <c><i>params</i></c> argument was invalid.
		/// @retval					SCE_TOOLKIT_NP_NOT_INITIALISED		The operation failed because the %NP %Toolkit library is not initialized.
		static int setVariables(TusSetVarsInputParams &params, bool async = true);
		
		/// @brief 
		/// Gets a specified user's TUS variables.
		///
		/// Gets a specified user's TUS variables.
		///
		/// @param 	vars			A <c>Future</c> object, which receives the TUS variables.
		/// @param 	params			The input parameters required to get a specified user's TUS variables.
		/// @param	async			A flag that indicates whether the function is non-blocking or blocking.
		///							Defaults to true so the function is non-blocking by default.
		///
		/// @retval					SCE_TOOLKIT_NP_SUCCESS				The operation was successful.
		/// @retval					SCE_TOOLKIT_NP_OFFLINE				The operation failed because the user is not connected to the network.  
		/// @retval					SCE_TOOLKIT_NP_INVALID_POINTER		The operation failed because the <c><i>vars</i></c> or <c><i>params</i></c> argument was invalid.
		/// @retval					SCE_TOOLKIT_NP_NOT_INITIALISED		The operation failed because the %NP %Toolkit library is not initialized.
		static int getVariables(sce::Toolkit::NP::Utilities::Future<std::vector<SceNpTusVariable> > *vars, TusGetVarsInputParams &params, bool async = true);

		/// @brief 
		/// Sets a specified user's TUS binary data.
		///
		/// Sets a specified user's TUS binary data.
		///
		/// @param 	params			The input parameters required to set a specified user's TUS data.
		/// @param	async			A flag that indicates whether the function is non-blocking or blocking.
		///							Defaults to true so the function is non-blocking by default.
		///
		/// @retval					SCE_TOOLKIT_NP_SUCCESS				The operation was successful.
		/// @retval					SCE_TOOLKIT_NP_OFFLINE				The operation failed because the user is not connected to the network.  
		/// @retval					SCE_TOOLKIT_NP_INVALID_POINTER		The operation failed because the <c><i>params</i></c> argument was invalid.
		/// @retval					SCE_TOOLKIT_NP_NOT_INITIALISED		The operation failed because the %NP %Toolkit library is not initialized.
		static int setData(TusSetDataInputParams &params, bool async = true);

		/// @brief 
		/// Gets a specified user's TUS binary data.
		///
		/// Gets a specified user's TUS binary data.
		///
		/// @param 	data			A <c>Future</c> object, which receives the specified user's TUS data.
		/// @param 	params			The input parameters required to get a specified user's TUS data.
		/// @param	async			A flag that indicates whether the function is non-blocking or blocking.
		///							Defaults to true so the function is non-blocking by default.
		///
		/// @retval					SCE_TOOLKIT_NP_SUCCESS				The operation was successful.
		/// @retval					SCE_TOOLKIT_NP_OFFLINE				The operation failed because the user is not connected to the network.  
		/// @retval					SCE_TOOLKIT_NP_INVALID_POINTER		The operation failed because the <c><i>params</i></c> or <c><i>data</i></c>argument was invalid.
		/// @retval					SCE_TOOLKIT_NP_NOT_INITIALISED		The operation failed because the %NP %Toolkit library is not initialized.
		static int getData(sce::Toolkit::NP::Utilities::Future<TusDataOutput> *data, TusGetDataInputParams &params, bool async = true);
	};
	}

}//end NP
}//end Toolkit
}//end Sce
#endif
